// XISLCombExchangeTag.cpp: CXISLCombExchangeTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLCombExchangeTag.h"
#include "XISLExchangeTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLCombExchangeTag::CXISLCombExchangeTag(CXISLTag *pParent,int nCombType)
{
	m_pParentTag = pParent;

	switch(nCombType)
	{
	case ID_TAG_SEQ:
		m_nTagType = ID_TAG_SEXCHANGE;
		m_nBmpID = IDB_SEQ;
		break;
	case ID_TAG_PAR:
		m_nTagType = ID_TAG_PEXCHANGE;
		m_nBmpID = IDB_PAR;
		break;
	case ID_TAG_ALT:
		m_nTagType = ID_TAG_AEXCHANGE;
		m_nBmpID = IDB_ALT;
		break;
	default:
		ASSERT(NULL);
		break;
	}
}

CXISLCombExchangeTag::~CXISLCombExchangeTag()
{
	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);
		if(pExcItem->m_nTagType == ID_TAG_EXCHANGE)
			delete (CXISLExchangeTag*)pExcItem;
		else
			delete (CXISLCombExchangeTag*)pExcItem;
	}
}

CXISLCombExchangeTag::CXISLCombExchangeTag(const CXISLCombExchangeTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	for(int i=0; i<cpXISL.m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = cpXISL.m_ExchangeList.FindIndex(i);
		m_ExchangeList.AddTail(cpXISL.m_ExchangeList.GetAt(pos));
	}
}

CXISLCombExchangeTag& CXISLCombExchangeTag::operator=(const CXISLCombExchangeTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		for(int i=0; i<m_ExchangeList.GetCount(); i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);
			if(pExcItem->m_nTagType == ID_TAG_EXCHANGE)
				delete (CXISLExchangeTag*)pExcItem;
			else
				delete (CXISLCombExchangeTag*)pExcItem;
		}
		m_ExchangeList.RemoveAll();
		for(i=0; i<cpXISL.m_ExchangeList.GetCount(); i++)
		{
			POSITION pos = cpXISL.m_ExchangeList.FindIndex(i);
			m_ExchangeList.AddTail(cpXISL.m_ExchangeList.GetAt(pos));
		}
	}
	return *this;
}

//CXISLExchangeTag* CXISLDialogTag::InsertExchange(int nComb,LPCTSTR lpszURI="",CXISLTag *pPlaceTag=NULL);
//@\@Fw肵^ȌꏊɁCexchange}
//	Fint nComb			:comb
//@@@FLPCTSTR lpszURI	FURI
//		FCXISLTag *pPlaceTag		FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFIuWFNg̃|C^
CXISLExchangeTag* CXISLCombExchangeTag::InsertExchange(int nComb,LPCTSTR lpszURI,CXISLTag *pPlaceTag)
{
	CXISLExchangeTag *pExchangeTag;

	pExchangeTag = new CXISLExchangeTag((CXISLTag*)this,nComb,lpszURI);

	//pPlaceTagw肵ĂȂC̏ꏊ̌ɑ}
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pExchangeTag);
				break;
			}
		}
		return NULL;
	}
	else
		m_ExchangeList.AddTail((CXISLExcItem*)pExchangeTag);

	return pExchangeTag;
}

//CXISLExchangeTag* CXISLCombExchangeTag::InsertExchange(CXISLExchangeTag *pExcTag,CXISLTag *pPlaceTag)
//@\@Fw肵^ȌꏊɁCexchange𐶐
//	FCXISLExchangeTag *pExcTag	:}^O.NULLȂVK쐬
//		FCXISLTag *pPlaceTag		FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFIuWFNg̃|C^
CXISLExchangeTag* CXISLCombExchangeTag::InsertExchange(CXISLExchangeTag *pExcTag,CXISLTag *pPlaceTag)
{
	if(pExcTag)
		pExcTag->m_pParentTag = this;
	else
		ASSERT(NULL);

	//pPlaceTagw肵ĂȂC̏ꏊ̌ɑ}
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pExcTag);
				break;
			}
		}
		return NULL;
	}
	else
		m_ExchangeList.AddTail((CXISLExcItem*)pExcTag);

	return pExcTag;
}

//CXISLCombExchangeTag* CXISLCombExchangeTag::InsertCombExchange(int nCombType,CXISLTag *pPlaceTag=NULL);
//@\@F***_exchangȇ}
//@\	Fw肵^ȌꏊɁC***_exchange}C̃^OqɎ悤ɂ
//	Fint nCombType						:***_exchangẽ^Cvpar,alt,seq
//		FCXISLTag *pPlaceTag				FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFCXISLCombExchangeTag*@sFNULL
CXISLCombExchangeTag* CXISLCombExchangeTag::InsertCombExchange(int nCombType,CXISLTag *pPlaceTag)
{
	CXISLCombExchangeTag *pCombExchangeTag;

	pCombExchangeTag = new CXISLCombExchangeTag((CXISLTag*)this,nCombType);

	//pPlaceTagw肵ĂȂC̏ꏊɑ}CpPlaceTagqɈړ
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pCombExchangeTag);
				m_ExchangeList.RemoveAt(pos);
				((CXISLCombExchangeTag*)pCombExchangeTag)->InsertExchange((CXISLExchangeTag*)pTag);
				break;
			}
		}
	}
	else
		m_ExchangeList.AddTail((CXISLExcItem*)pCombExchangeTag);

	return pCombExchangeTag;
}

//CXISLCombExchangeTag* CXISLCombExchangeTag::InsertCombExchange(CXISLCombExchangeTag *pCombExcTag,CXISLTag *pPlaceTag)
//@\@F***_exchangȇ}
//@\	Fw肵^ȌꏊɁC***_exchange}C̃^OqɎ悤ɂ
//	FCXISLCombExchangeTag *pCombExcTag	:}^O.
//		FCXISLTag *pPlaceTag				FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFCXISLCombExchangeTag*@sFNULL
CXISLCombExchangeTag* CXISLCombExchangeTag::InsertCombExchange(CXISLCombExchangeTag *pCombExcTag,CXISLTag *pPlaceTag)
{
	if(pCombExcTag)
		pCombExcTag->m_pParentTag = this;
	else
		ASSERT(NULL);

	//pPlaceTagw肵ĂȂC̏ꏊɑ}CpPlaceTagqɈړ
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pCombExcTag);
				m_ExchangeList.RemoveAt(pos);
				pCombExcTag->InsertExchange((CXISLExchangeTag*)pTag);
				break;
			}
		}
	}
	else
		m_ExchangeList.AddTail((CXISLExcItem*)pCombExcTag);

	return pCombExcTag;
}

//LPCTSTR CXISLCombExchangeTag::GetXISLString()
//@\@F***_exchangeȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLCombExchangeTag::GetXISLString()
{
	m_strXISL = "<";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

		m_strXISL += pExcItem->GetXISLString();
	}

	m_strXISL += "</";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	return m_strXISL;
}

//int CXISLCombExchangeTag::GetItemCount()
//@\@F***_exchangeȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLCombExchangeTag::GetItemCount()
{
	int nCount = 0;

	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

		if(pExcItem->m_nTagType == ID_TAG_EXCHANGE)
			nCount += ((CXISLExchangeTag*)pExcItem)->GetItemCount();
		else
			nCount += ((CXISLCombExchangeTag*)pExcItem)->GetItemCount();
	}

	nCount++; //<***_exchange>̕

	return nCount;
}

//BOOL CXISLCombExchangeTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLCombExchangeTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[m_nTagType];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

		pExcItem->RegistXISLTree(pTree,hParent);
		/*
		if(pExcItem->m_nTagType == ID_TAG_EXCHANGE)
			((CXISLExchangeTag*)pExcItem)->RegistXISLTree(pTree,hParent);
		else
			((CXISLCombExchangeTag*)pExcItem)->RegistXISLTree(pTree,hParent);
		*/
  }

	return TRUE;
}

//CSize CXISLCombExchangeTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@F***_exchange̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLCombExchangeTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	//1D܂͎g`
	FlowBMP.LoadBitmap(m_nBmpID);
	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;
	pDC->MoveTo(nX,nY);

	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	nViewSizeX = nX;

	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);
	
	int nCount = m_ExchangeList.GetCount();
	//exchangeOȂ`
	if(nCount == 0)
	{
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
	}
	else
	{
		int nBX = nX;
		int nBY = nY;
		int *npExcPoint = new int[nCount];
		nY += 20;
		for(int i=0;i<nCount;i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

			FlowBMP.LoadBitmap(pExcItem->m_nBmpID);
			FlowBMP.GetBitmap(&bmp);
			if(m_nTagType != ID_TAG_SEXCHANGE && i==0)
			{
				nX = nX - (bmp.bmWidth - 10);
				nY += 50;
			}
			MemDC.SelectObject(&FlowBMP);
			pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
			pExcItem->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
			npExcPoint[i] = nX;
			nViewSizeX = nX + bmp.bmWidth/2;

			pDC->MoveTo(nBX,nBY);
			if(m_nTagType != ID_TAG_SEXCHANGE)
			{
				if(i == 0)
				{
					point[0].x = nBX;
					point[0].y = nBY+20;
					point[1].x = nX-10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				else
				{
					point[0].x = nBX;
					point[0].y = nBY+20;
					point[1].x = nX+10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				pDC->PolyBezierTo(point,3);
				//`
				pDC->MoveTo(nX+4,nY-6);
				pDC->LineTo(nX,nY);
				pDC->MoveTo(nX-4,nY-6);
				pDC->LineTo(nX,nY);
				nX = nX + bmp.bmWidth + 20;
			}
			else
			{
				pDC->LineTo(nX,nY);
				nBX = nX; nBY = nY + bmp.bmHeight;
				//`
				pDC->MoveTo(nX+4,nY-6);
				pDC->LineTo(nX,nY);
				pDC->MoveTo(nX-4,nY-6);
				pDC->LineTo(nX,nY);
				nY = nY + bmp.bmHeight + 20;
			}

			FlowBMP.DeleteObject();
		}

		if(m_nTagType == ID_TAG_SEXCHANGE)
		{
			pDC->MoveTo(nBX,nBY);
			nY += 10;
			pDC->LineTo(nX,nY);
		}
		else
		{
			nX = nBX;
			nY += bmp.bmHeight;
			nBY = nY; 
			if(m_nTagType == ID_TAG_PEXCHANGE)
			{
				nY += 20;
				for(int i=0;i<nCount;i++)
				{
					pDC->MoveTo(npExcPoint[i],nBY);
					pDC->LineTo(npExcPoint[i],nY);
				}
				pDC->MoveTo(npExcPoint[0],nY);
				if(nCount == 1)
					pDC->LineTo(nBX,nY);
				else
					pDC->LineTo(npExcPoint[nCount-1],nY);
				pDC->MoveTo(nBX,nY);
				nY += 30;
				pDC->LineTo(nBX,nY);
			}
			else if(m_nTagType == ID_TAG_AEXCHANGE)
			{
				nY += 60;
				for(int i=0;i<nCount;i++)
				{
					pDC->MoveTo(npExcPoint[i],nBY);
					if(i == 0)
					{
						point[0].x = npExcPoint[i]+10;
						point[0].y = nBY+20;
						point[1].x = npExcPoint[i]-10;
						point[1].y = nBY+20;
						point[2].x = nX;
						point[2].y = nY;
					}
					else
					{
						point[0].x = npExcPoint[i];
						point[0].y = nBY+20;
						point[1].x = npExcPoint[i]+10;
						point[1].y = nBY+40;
						point[2].x = nX;
						point[2].y = nY;
					}
					pDC->PolyBezierTo(point,3);
				}
			}
		}
		nY += 10;
		pDC->LineTo(nX,nY);
		//`
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
		delete [] npExcPoint;
	}

	nViewSizeY = nY;

	MemDC.SelectObject(pOldBMP);
	MemDC.DeleteDC();

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

//CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLCombExchangeTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		for(int i=0;i<m_ExchangeList.GetCount();i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLExcItem* pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

			pTag = pExcItem->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}

BOOL CXISLCombExchangeTag::DeleteCombExchange(CXISLExchangeTag *pExcTag,CXISLTag *pPlaceTag)
{
	POSITION pos = m_ExchangeList.Find(pExcTag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	m_ExchangeList.RemoveAt(posdel);
	delete pExcTag;
	pExcTag=NULL;
	return TRUE;
}

void CXISLCombExchangeTag::DeleteCombExchangeList()
{
	CXISLCombExchangeTag *pCExcTag;
	CXISLExchangeTag *pExcTag;
	while(!m_ExchangeList.IsEmpty()){
		pExcTag = (CXISLExchangeTag *)m_ExchangeList.GetHead();
		if(pExcTag->m_nTagType == ID_TAG_EXCHANGE){	
			pExcTag->DeleteAllAct();
			pExcTag->DeleteAllOpr();
			pExcTag->DeletePromptList();
			DeleteCombExchange(pExcTag);
		}
		else if(pExcTag->m_nTagType == ID_TAG_SEXCHANGE || pExcTag->m_nTagType == ID_TAG_PEXCHANGE || pExcTag->m_nTagType == ID_TAG_AEXCHANGE){
			pCExcTag = (CXISLCombExchangeTag *)m_ExchangeList.GetHead();
			pCExcTag->DeleteCombExchangeList();
			DeleteCombExchange((CXISLExchangeTag *)pCExcTag);
		}
	}
}